-- Atualizar políticas RLS para considerar papel operacional

-- Gallery: operacional pode fazer CRUD
DROP POLICY IF EXISTS "Admins can insert gallery images" ON gallery_images;
DROP POLICY IF EXISTS "Admins can update gallery images" ON gallery_images;
DROP POLICY IF EXISTS "Admins can delete gallery images" ON gallery_images;

CREATE POLICY "Admins and operacional can insert gallery images"
ON gallery_images FOR INSERT
TO authenticated
WITH CHECK (
  has_role(auth.uid(), 'admin'::app_role) OR 
  has_role(auth.uid(), 'operacional'::app_role)
);

CREATE POLICY "Admins and operacional can update gallery images"
ON gallery_images FOR UPDATE
TO authenticated
USING (
  has_role(auth.uid(), 'admin'::app_role) OR 
  has_role(auth.uid(), 'operacional'::app_role)
);

CREATE POLICY "Admins and operacional can delete gallery images"
ON gallery_images FOR DELETE
TO authenticated
USING (
  has_role(auth.uid(), 'admin'::app_role) OR 
  has_role(auth.uid(), 'operacional'::app_role)
);

-- Events: operacional pode fazer CRUD
DROP POLICY IF EXISTS "Admins can insert events" ON events;
DROP POLICY IF EXISTS "Admins can update events" ON events;
DROP POLICY IF EXISTS "Admins can delete events" ON events;

CREATE POLICY "Admins and operacional can insert events"
ON events FOR INSERT
TO authenticated
WITH CHECK (
  has_role(auth.uid(), 'admin'::app_role) OR 
  has_role(auth.uid(), 'operacional'::app_role)
);

CREATE POLICY "Admins and operacional can update events"
ON events FOR UPDATE
TO authenticated
USING (
  has_role(auth.uid(), 'admin'::app_role) OR 
  has_role(auth.uid(), 'operacional'::app_role)
);

CREATE POLICY "Admins and operacional can delete events"
ON events FOR DELETE
TO authenticated
USING (
  has_role(auth.uid(), 'admin'::app_role) OR 
  has_role(auth.uid(), 'operacional'::app_role)
);

-- Certificates: operacional pode fazer CRUD
DROP POLICY IF EXISTS "Admins can insert certificates" ON certificates;
DROP POLICY IF EXISTS "Admins can update certificates" ON certificates;
DROP POLICY IF EXISTS "Admins can delete certificates" ON certificates;

CREATE POLICY "Admins and operacional can insert certificates"
ON certificates FOR INSERT
TO authenticated
WITH CHECK (
  has_role(auth.uid(), 'admin'::app_role) OR 
  has_role(auth.uid(), 'operacional'::app_role)
);

CREATE POLICY "Admins and operacional can update certificates"
ON certificates FOR UPDATE
TO authenticated
USING (
  has_role(auth.uid(), 'admin'::app_role) OR 
  has_role(auth.uid(), 'operacional'::app_role)
);

CREATE POLICY "Admins and operacional can delete certificates"
ON certificates FOR DELETE
TO authenticated
USING (
  has_role(auth.uid(), 'admin'::app_role) OR 
  has_role(auth.uid(), 'operacional'::app_role)
);