import Header from "@/components/layout/Header";
import Footer from "@/components/layout/Footer";
import { Card } from "@/components/ui/card";
import { FileText } from "lucide-react";

const TermosUso = () => {
  return (
    <div className="min-h-screen">
      <Header />
      <main className="pt-20">
        <section className="py-20 bg-gradient-to-br from-secondary to-secondary/80 text-white">
          <div className="container mx-auto px-4 text-center">
            <FileText className="w-16 h-16 mx-auto mb-4" />
            <h1 className="mb-6">Termos de Uso</h1>
            <p className="text-xl text-gray-200 max-w-3xl mx-auto">
              Condições gerais de uso do site e contratação de serviços
            </p>
          </div>
        </section>

        <section className="py-16 bg-background">
          <div className="container mx-auto px-4 max-w-4xl">
            <Card className="p-8">
              <div className="prose prose-slate max-w-none">
                <p className="text-sm text-muted-foreground mb-4">
                  Última atualização: Janeiro de 2025
                </p>

                <h2 className="text-2xl font-bold mb-4 mt-8">1. Aceitação dos Termos</h2>
                <p className="mb-4">
                  Ao acessar e utilizar este site, você concorda com os presentes Termos de Uso. Se
                  você não concordar com estes termos, não utilize o site.
                </p>

                <h2 className="text-2xl font-bold mb-4 mt-8">2. Sobre a Empresa</h2>
                <p className="mb-4">
                  A <strong>Saúde Ambiental</strong> é uma empresa especializada em controle de
                  pragas, higienização e sanitização, devidamente registrada e licenciada pelos
                  órgãos competentes (ADAGRO, IBAMA, Vigilância Sanitária, DIRCON, SEMAN, CPRH, ANVISA, CRQ, NR-31, NR-33 e NR-35).
                </p>

                <h2 className="text-2xl font-bold mb-4 mt-8">3. Serviços Oferecidos</h2>
                <p className="mb-4">Oferecemos os seguintes serviços:</p>
                <ul className="list-disc pl-6 mb-4 space-y-2">
                  <li>Desinsetização e controle de pragas urbanas</li>
                  <li>Limpeza e higienização de reservatórios de água</li>
                  <li>Sanitização de ambientes</li>
                  <li>Outros serviços relacionados à saúde ambiental</li>
                </ul>

                <h2 className="text-2xl font-bold mb-4 mt-8">4. Contratação de Serviços</h2>
                <p className="mb-4">A contratação dos nossos serviços envolve:</p>
                <ul className="list-disc pl-6 mb-4 space-y-2">
                  <li>Solicitação de orçamento sem compromisso</li>
                  <li>Vistoria técnica prévia quando necessário</li>
                  <li>Apresentação de proposta formal</li>
                  <li>Assinatura de contrato ou ordem de serviço</li>
                  <li>Execução conforme cronograma acordado</li>
                  <li>Emissão de certificado e/ou laudo técnico</li>
                </ul>

                <h2 className="text-2xl font-bold mb-4 mt-8">5. Garantias</h2>
                <p className="mb-4">
                  Todos os nossos serviços possuem garantia de qualidade. O prazo de garantia varia
                  conforme o tipo de serviço:
                </p>
                <ul className="list-disc pl-6 mb-4 space-y-2">
                  <li>Desinsetização: até 3 meses</li>
                  <li>Limpeza de reservatórios: conforme legislação vigente</li>
                  <li>Sanitização: eficácia imediata com manutenção recomendada</li>
                </ul>

                <h2 className="text-2xl font-bold mb-4 mt-8">6. Responsabilidades do Cliente</h2>
                <p className="mb-4">O cliente deve:</p>
                <ul className="list-disc pl-6 mb-4 space-y-2">
                  <li>Fornecer informações corretas e completas</li>
                  <li>Permitir acesso às áreas que necessitam tratamento</li>
                  <li>Seguir as orientações técnicas fornecidas</li>
                  <li>Efetuar o pagamento conforme acordado</li>
                  <li>Comunicar problemas dentro do prazo de garantia</li>
                </ul>

                <h2 className="text-2xl font-bold mb-4 mt-8">7. Cancelamento e Reagendamento</h2>
                <p className="mb-4">
                  Cancelamentos e reagendamentos devem ser comunicados com pelo menos 24 horas de
                  antecedência. Cancelamentos sem aviso prévio podem estar sujeitos a taxa
                  administrativa.
                </p>

                <h2 className="text-2xl font-bold mb-4 mt-8">8. Propriedade Intelectual</h2>
                <p className="mb-4">
                  Todo o conteúdo deste site (textos, imagens, logos, ícones) é propriedade da
                  Saúde Ambiental ou utilizado sob licença. É proibida a reprodução sem autorização
                  prévia.
                </p>

                <h2 className="text-2xl font-bold mb-4 mt-8">9. Limitação de Responsabilidade</h2>
                <p className="mb-4">
                  A Saúde Ambiental não se responsabiliza por:
                </p>
                <ul className="list-disc pl-6 mb-4 space-y-2">
                  <li>Danos causados por informações incorretas fornecidas pelo cliente</li>
                  <li>Infestações recorrentes por falta de manutenção preventiva</li>
                  <li>Indisponibilidade temporária do site</li>
                  <li>Problemas estruturais identificados durante os serviços</li>
                </ul>

                <h2 className="text-2xl font-bold mb-4 mt-8">10. Uso do Site</h2>
                <p className="mb-4">É proibido:</p>
                <ul className="list-disc pl-6 mb-4 space-y-2">
                  <li>Utilizar o site para fins ilegais</li>
                  <li>Tentar acessar áreas restritas</li>
                  <li>Enviar malware ou conteúdo malicioso</li>
                  <li>Fazer uso abusivo dos formulários de contato</li>
                </ul>

                <h2 className="text-2xl font-bold mb-4 mt-8">11. Preços e Pagamentos</h2>
                <p className="mb-4">
                  Os preços apresentados em orçamentos são válidos conforme prazo especificado. O
                  pagamento pode ser realizado conforme condições acordadas (à vista, parcelado,
                  boleto, transferência).
                </p>

                <h2 className="text-2xl font-bold mb-4 mt-8">12. Legislação Aplicável</h2>
                <p className="mb-4">
                  Estes termos são regidos pelas leis brasileiras. Qualquer litígio será resolvido
                  no foro da comarca de Recife/PE.
                </p>

                <h2 className="text-2xl font-bold mb-4 mt-8">13. Alterações</h2>
                <p className="mb-4">
                  Reservamo-nos o direito de modificar estes Termos de Uso a qualquer momento.
                  Alterações entrarão em vigor imediatamente após publicação no site.
                </p>

                <h2 className="text-2xl font-bold mb-4 mt-8">14. Contato</h2>
                <p className="mb-4">
                  Dúvidas sobre estes termos? Entre em contato:
                </p>
                <ul className="list-none mb-4 space-y-2">
                  <li>
                    <strong>E-mail:</strong> contato@saudeambiental.com.br
                  </li>
                  <li>
                    <strong>Telefone:</strong> (81) 3000-1234
                  </li>
                  <li>
                    <strong>WhatsApp:</strong> (81) 99999-9999
                  </li>
                </ul>
              </div>
            </Card>
          </div>
        </section>
      </main>
      <Footer />
    </div>
  );
};

export default TermosUso;
