/**
 * Configuração centralizada da empresa
 * Edite os valores abaixo com os dados reais da Hecol Saúde Ambiental
 */

export const company = {
  nome: "Hecol Saúde Ambiental",
  razaoSocial: "Hecol Empreendimentos e Serviços Ltda",
  cnpj: "15.551.751/0001-73",
  email: "vendas@hecol.com.br",
  emails: [
    "vendas@hecol.com.br",
    "qualidade@hecol.com.br",
    "financeiro@hecol.com.br"
  ],
  telefones: [
    "+55 81 3023-0800"
  ],
  whatsapps: {
    central: "+55 81 3023-0800",
    vendas: "+55 81 99857-8596",
    operacional: "+55 81 98263-6946"
  },
  endereco: {
    rua: "Rua Coronel Mizael de Mendonça",
    numero: "94",
    bairro: "San Martin",
    cidade: "Recife",
    uf: "PE",
    cep: "50761-190"
  },
  localizacao: {
    lat: -8.0697273,
    lng: -34.9364505
  },
  social: {
    instagram: "https://instagram.com/hecol",
    linkedin: "https://linkedin.com/company/hecol",
    facebook: "https://facebook.com/hecol"
  },
  whatsapp: "https://wa.me/5581998578596?text=Ol%C3%A1%2C%20quero%20um%20or%C3%A7amento"
};

/**
 * Retorna o endereço formatado para exibição
 */
export const getEnderecoCompleto = () => {
  const { rua, numero, bairro, cidade, uf, cep } = company.endereco;
  return `${rua}, ${numero} – ${bairro}, ${cidade}/${uf}, CEP ${cep}`;
};

/**
 * Retorna o endereço codificado para URL do Google Maps
 */
export const getEnderecoUrlEncoded = () => {
  const { rua, numero, bairro, cidade, uf, cep } = company.endereco;
  return encodeURIComponent(`${rua}, ${numero}, ${bairro}, ${cidade}, ${uf}, ${cep}`);
};

/**
 * Retorna a URL do Google Maps Directions
 */
export const getGoogleMapsDirectionsUrl = () => {
  return `https://www.google.com/maps/dir/?api=1&destination=${getEnderecoUrlEncoded()}`;
};
