import * as React from "react";
import { Slot } from "@radix-ui/react-slot";
import { cva, type VariantProps } from "class-variance-authority";

import { cn } from "@/lib/utils";

const buttonVariants = cva(
  "inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium ring-offset-background transition-all duration-200 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-brand-red-focus focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg]:size-4 [&_svg]:shrink-0 will-change-transform transform-gpu",
  {
    variants: {
      variant: {
        default: "bg-brand-red text-brand-red-contrast hover:bg-brand-red-hover active:bg-brand-red-active hover:scale-[1.03] hover:px-[calc(1rem+2px)] shadow-md hover:shadow-lg motion-reduce:hover:scale-100 motion-reduce:hover:px-4",
        destructive: "bg-brand-red text-brand-red-contrast hover:bg-brand-red-hover active:bg-brand-red-active hover:scale-[1.03] motion-reduce:hover:scale-100",
        outline: "border-2 border-foreground bg-transparent text-foreground hover:bg-brand-red hover:text-brand-red-contrast hover:border-brand-red active:bg-brand-red-active hover:scale-[1.03] hover:px-[calc(0.75rem+2px)] motion-reduce:hover:scale-100 motion-reduce:hover:px-3",
        secondary: "bg-secondary text-secondary-foreground hover:bg-brand-red hover:text-brand-red-contrast active:bg-brand-red-active hover:scale-[1.03] hover:px-[calc(1rem+2px)] motion-reduce:hover:scale-100 motion-reduce:hover:px-4",
        ghost: "hover:bg-brand-red hover:text-brand-red-contrast active:bg-brand-red-active hover:scale-[1.03] motion-reduce:hover:scale-100",
        link: "text-primary underline-offset-4 hover:underline hover:text-brand-red",
        hero: "bg-brand-red text-brand-red-contrast hover:bg-brand-red-hover active:bg-brand-red-active shadow-lg hover:shadow-xl hover:scale-[1.04] duration-200 font-semibold motion-reduce:hover:scale-100",
        cta: "bg-brand-red text-brand-red-contrast hover:bg-brand-red-hover active:bg-brand-red-active hover:shadow-xl hover:scale-[1.04] duration-200 font-semibold motion-reduce:hover:scale-100",
        whatsapp: "bg-[#25D366] text-white hover:bg-brand-red hover:text-brand-red-contrast active:bg-brand-red-active shadow-md hover:shadow-lg hover:scale-[1.03] motion-reduce:hover:scale-100",
      },
      size: {
        default: "h-10 px-4 py-2",
        sm: "h-9 rounded-md px-3",
        lg: "h-12 rounded-md px-8 text-base",
        xl: "h-14 rounded-lg px-10 text-lg",
        icon: "h-10 w-10",
      },
    },
    defaultVariants: {
      variant: "default",
      size: "default",
    },
  },
);

export interface ButtonProps
  extends React.ButtonHTMLAttributes<HTMLButtonElement>,
    VariantProps<typeof buttonVariants> {
  asChild?: boolean;
}

const Button = React.forwardRef<HTMLButtonElement, ButtonProps>(
  ({ className, variant, size, asChild = false, ...props }, ref) => {
    const Comp = asChild ? Slot : "button";
    return <Comp className={cn(buttonVariants({ variant, size, className }))} ref={ref} {...props} />;
  },
);
Button.displayName = "Button";

export { Button, buttonVariants };
