import { useState, useEffect } from "react";
import { useLocation, useNavigate } from "react-router-dom";
import LanguageSwitcher from "./LanguageSwitcher";
import Navbar from "@/components/header/Navbar";

const Header = () => {
  const [isScrolled, setIsScrolled] = useState(false);
  const [logoUrl, setLogoUrl] = useState("");
  const location = useLocation();
  const navigate = useNavigate();

  const handleLogoClick = (e: React.MouseEvent) => {
    e.preventDefault();
    navigate("/");
    window.scrollTo({ top: 0, behavior: "smooth" });
  };

  useEffect(() => {
    setLogoUrl('/logo/hecol-logo-transparent.webp');
  }, []);

  useEffect(() => {
    const handleScroll = () => {
      setIsScrolled(window.scrollY > 20);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  // Verifica se está na página inicial (Hero)
  const isHomePage = location.pathname === "/";

  return (
    <header
      className={`fixed top-0 left-0 right-0 z-50 transition-all duration-300 ${
        isScrolled || !isHomePage
          ? "bg-[#0E1B2E]/95 backdrop-blur-md shadow-md"
          : "bg-transparent"
      }`}
    >
      <div className="container mx-auto px-4">
        <nav className="flex items-center justify-between h-[60px] md:h-[64px] lg:h-[72px]">
          {/* Logo */}
          <a href="/" onClick={handleLogoClick} className="flex items-center">
            {logoUrl && (
              <img 
                src={logoUrl} 
                alt="Hecol" 
                className="h-12 sm:h-13 md:h-14 lg:h-16 w-auto object-contain"
              />
            )}
          </a>

          {/* Navigation com Mega Menu */}
          <Navbar isScrolled={isScrolled} isHomePage={isHomePage} />

          {/* Language Switcher */}
          <div className="hidden lg:flex items-center">
            <LanguageSwitcher isWhite={true} />
          </div>
        </nav>
      </div>
      {/* Red border line below header - apenas quando não está transparente */}
      {(!isHomePage || isScrolled) && (
        <div className="w-full h-[2px] bg-brand-red" />
      )}
    </header>
  );
};

export default Header;
