import { Link } from "react-router-dom";
import { Mail, Phone, MapPin, Facebook, Instagram, Linkedin, MessageCircle, Clock } from "lucide-react";
import { company, getEnderecoCompleto } from "@/config/company";

const Footer = () => {
  const currentYear = new Date().getFullYear();

  return (
    <footer className="bg-brand-red text-brand-red-contrast">
      <div className="container mx-auto px-4 py-12 relative before:content-none after:content-none" style={{ backgroundImage: 'none' }}>
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 relative before:content-none after:content-none" style={{ backgroundImage: 'none' }}>
          {/* Sobre */}
          <div>
            <h3 className="text-xl font-bold mb-4 text-white">{company.nome}</h3>
            <p className="text-sm text-white/90 mb-2">
              CNPJ: {company.cnpj}
            </p>
            <p className="text-sm text-white/90 mb-2">
              Razão social: {company.razaoSocial}
            </p>
            <p className="text-sm text-white/90 mb-4">
              Especialistas em controle de pragas e higienização com excelência e
              segurança há mais de 15 anos.
            </p>
            <div className="flex space-x-3">
              <a
                href={company.social.facebook}
                target="_blank"
                rel="noopener noreferrer"
                className="p-2 bg-white/10 rounded-full hover:bg-brand-red hover:scale-110 transition-all duration-200 motion-reduce:hover:scale-100"
                aria-label="Facebook"
              >
                <Facebook className="w-5 h-5" />
              </a>
              <a
                href={company.social.instagram}
                target="_blank"
                rel="noopener noreferrer"
                className="p-2 bg-white/10 rounded-full hover:bg-brand-red hover:scale-110 transition-all duration-200 motion-reduce:hover:scale-100"
                aria-label="Instagram"
              >
                <Instagram className="w-5 h-5" />
              </a>
              <a
                href={company.social.linkedin}
                target="_blank"
                rel="noopener noreferrer"
                className="p-2 bg-white/10 rounded-full hover:bg-brand-red hover:scale-110 transition-all duration-200 motion-reduce:hover:scale-100"
                aria-label="LinkedIn"
              >
                <Linkedin className="w-5 h-5" />
              </a>
            </div>
          </div>

          {/* Links Rápidos */}
          <div>
            <h4 className="text-lg font-semibold mb-4 text-white">Links Rápidos</h4>
            <ul className="space-y-2">
              <li>
                <Link
                  to="/quem-somos"
                  className="text-sm text-white/90 hover:text-white hover:underline transition-all duration-150"
                >
                  Sobre Nós
                </Link>
              </li>
              <li>
                <Link
                  to="/servicos"
                  className="text-sm text-white/90 hover:text-white hover:underline transition-all duration-150"
                >
                  Serviços
                </Link>
              </li>
              <li>
                <Link
                  to="/galeria"
                  className="text-sm text-white/90 hover:text-white hover:underline transition-all duration-150"
                >
                  Galeria
                </Link>
              </li>
              <li>
                <Link
                  to="/eventos"
                  className="text-sm text-white/90 hover:text-white hover:underline transition-all duration-150"
                >
                  Eventos
                </Link>
              </li>
              <li>
                <Link
                  to="/trabalhe-conosco"
                  className="text-sm text-white/90 hover:text-white hover:underline transition-all duration-150"
                >
                  Trabalhe Conosco
                </Link>
              </li>
            </ul>
          </div>

          {/* Serviços */}
          <div>
            <h4 className="text-lg font-semibold mb-4 text-white">Nossos Serviços</h4>
            <ul className="space-y-2">
              <li className="text-sm text-white/90">Desinsetização</li>
              <li className="text-sm text-white/90">Limpeza de Reservatórios</li>
              <li className="text-sm text-white/90">Sanitização</li>
              <li className="text-sm text-white/90">Controle de Pragas</li>
              <li className="text-sm text-white/90">Higienização Industrial</li>
            </ul>
          </div>

          {/* Contato */}
          <div>
            <h4 className="text-lg font-semibold mb-4 text-white">Contato</h4>
            <ul className="space-y-3">
              <li className="flex items-start space-x-2">
                <MapPin className="w-5 h-5 text-white flex-shrink-0 mt-0.5" />
                <span className="text-sm text-white/90">
                  {getEnderecoCompleto()}
                </span>
              </li>
              {company.telefones.map((tel, idx) => (
                <li key={idx} className="flex items-center space-x-2">
                  <Phone className="w-5 h-5 text-white" />
                  <a
                    href={`tel:${tel.replace(/\s/g, '')}`}
                    className="text-sm text-white/90 hover:text-white hover:underline transition-all"
                  >
                    {tel}
                  </a>
                </li>
              ))}
              {Object.entries(company.whatsapps).map(([key, number]) => (
                <li key={key} className="flex items-center space-x-2">
                  <MessageCircle className="w-5 h-5 text-white" />
                  <a
                    href={`https://wa.me/${number.replace(/\D/g, "")}`}
                    target="_blank"
                    rel="noopener noreferrer"
                    className="text-sm text-white/90 hover:text-white hover:underline transition-all"
                  >
                    WhatsApp {key}: {number}
                  </a>
                </li>
              ))}
              <li className="flex items-center space-x-2">
                <Mail className="w-5 h-5 text-white" />
                <div className="text-sm text-white/90">
                  {company.emails.map((email, idx) => (
                    <a
                      key={email}
                      href={`mailto:${email}`}
                      className={`block hover:text-white hover:underline transition-all ${
                        idx > 0 ? "mt-1" : ""
                      }`}
                    >
                      {email}
                    </a>
                  ))}
                </div>
              </li>
              <li className="flex items-center space-x-2">
                <Clock className="w-5 h-5 text-white" />
                <span className="text-sm text-white/90">Serviços 24 horas</span>
              </li>
            </ul>
          </div>
        </div>

        {/* Certificações e Licenças */}
        <div className="mt-12 pt-8 relative before:content-none after:content-none" style={{ backgroundImage: 'none' }}>
          <div className="text-center mb-6">
            <p className="text-sm text-white/90 mb-2">Certificações e Conformidades:</p>
            <p className="text-xs text-white/80">
              ADAGRO • IBAMA • Vigilância Sanitária • DIRCON • SEMAN • CPRH • ANVISA • CRQ • NR-31 • NR-33 • NR-35
            </p>
          </div>

          {/* Bottom Bar */}
          <div className="flex flex-col md:flex-row justify-between items-center space-y-4 md:space-y-0">
            <p className="text-sm text-white/80">
              © {currentYear} {company.nome}. CNPJ: {company.cnpj}. Todos os direitos
              reservados.
            </p>
            <div className="flex flex-wrap gap-x-4 gap-y-2">
              <Link
                to="/politica-privacidade"
                className="text-xs text-white/80 hover:text-white hover:underline transition-all duration-150"
              >
                Política de Privacidade
              </Link>
              <Link
                to="/politica-cookies"
                className="text-xs text-white/80 hover:text-white hover:underline transition-all duration-150"
              >
                Política de Cookies
              </Link>
              <Link
                to="/termos-uso"
                className="text-xs text-white/80 hover:text-white hover:underline transition-all duration-150"
              >
                Termos de Uso
              </Link>
              <Link
                to="/lgpd"
                className="text-xs text-white/80 hover:text-white hover:underline transition-all duration-150"
              >
                LGPD
              </Link>
              <button
                onClick={() => {
                  const event = new CustomEvent('openCookiePreferences');
                  window.dispatchEvent(event);
                }}
                className="text-xs text-white/80 hover:text-white hover:underline transition-all duration-150"
              >
                Gerenciar Cookies
              </button>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
