import { Link } from "react-router-dom";
import { Briefcase } from "lucide-react";
import { useLanguage } from "@/lib/i18n/LanguageContext";

const FloatingJobButton = () => {
  const { t } = useLanguage();

  return (
    <div className="fixed right-4 top-32 z-40 animate-fade-in">
      {/* Thought bubble */}
      <Link
        to="/trabalhe-conosco"
        className="group relative flex items-center gap-2 bg-brand-red text-white px-4 py-3 rounded-2xl shadow-lg hover:bg-brand-red-hover hover:scale-105 transition-all duration-300"
      >
        <Briefcase className="w-5 h-5" />
        <span className="font-semibold text-sm whitespace-nowrap">
          {t.nav.trabalheConosco}
        </span>
        
        {/* Thought bubble tail - small circles */}
        <div className="absolute -bottom-2 right-4 w-3 h-3 bg-brand-red rounded-full group-hover:bg-brand-red-hover transition-colors" />
        <div className="absolute -bottom-4 right-2 w-2 h-2 bg-brand-red rounded-full group-hover:bg-brand-red-hover transition-colors" />
      </Link>
    </div>
  );
};

export default FloatingJobButton;
