import { Headset, Shield, FileCheck, Sparkles, Bug, BookOpen, BadgeCheck, Repeat } from "lucide-react";
import { Card } from "@/components/ui/card";

const reasons = [
  {
    icon: Headset,
    title: "Atendimento rápido e humanizado",
    description:
      "Orçamento em até 24 horas, WhatsApp com respostas imediatas e técnicos educados e identificados.",
  },
  {
    icon: Shield,
    title: "Uso de produtos seguros e certificados",
    description:
      "Produtos aprovados pela ANVISA, opções ecológicas e pet friendly com segurança para todos.",
  },
  {
    icon: FileCheck,
    title: "Garantia por escrito",
    description:
      "Garantia clara em contrato (ex: 3 meses) e retorno gratuito se o problema persistir.",
  },
  {
    icon: Sparkles,
    title: "Tecnologia e inovação",
    description:
      "Relatórios digitais com fotos, agendamento online e lembretes de manutenção preventiva.",
  },
  {
    icon: Bug,
    title: "Especialização técnica",
    description:
      "Controle de pragas urbanas, dedetização para condomínios e empresas, cupins, ratos, baratas e escorpiões.",
  },
  {
    icon: BookOpen,
    title: "Educação do cliente",
    description:
      "Orientações pós-serviço, conteúdo educativo e prevenção contínua como parte do serviço.",
  },
  {
    icon: BadgeCheck,
    title: "Imagem profissional",
    description:
      "Equipe uniformizada, veículos identificados, marca forte e avaliações positivas no Google.",
  },
  {
    icon: Repeat,
    title: "Programas de fidelização",
    description:
      "Planos anuais com desconto, manutenção preventiva periódica e benefícios para clientes recorrentes.",
  },
];

const WhyChoose = () => {
  return (
    <section id="por-que-escolher" className="bg-background border-t-2 border-brand-red-divider">
      <div className="container mx-auto px-4 py-20">
        <div className="text-center mb-16">
          <h2 className="mb-4">Por que escolher a Hecol Saúde Ambiental?</h2>
          <p className="text-lg text-muted-foreground max-w-2xl mx-auto">
            Diferenciais que fazem da Hecol Saúde Ambiental a melhor escolha para proteção e higienização
            do seu espaço.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          {reasons.map((reason, index) => (
            <Card
              key={reason.title}
              className="p-6 hover:shadow-xl transition-all duration-300 hover:-translate-y-2 animate-fade-in-up"
              style={{ animationDelay: `${index * 75}ms` }}
            >
              <div className="mb-4">
                <div className="inline-flex items-center justify-center w-14 h-14 bg-primary/10 rounded-full">
                  <reason.icon className="w-7 h-7 text-primary" />
                </div>
              </div>
              <h3 className="text-xl font-bold mb-3">{reason.title}</h3>
              <p className="text-muted-foreground">{reason.description}</p>
            </Card>
          ))}
        </div>
      </div>
    </section>
  );
};

export default WhyChoose;
