import { Card } from "@/components/ui/card";
import { Star, Quote } from "lucide-react";

const testimonials = [
  {
    name: "Maria Silva",
    role: "Síndica - Condomínio Jardim Atlântico",
    content:
      "Excelente empresa! Atendimento rápido, equipe educada e serviço de altíssima qualidade. Nosso condomínio está livre de pragas há mais de 2 anos.",
    rating: 5,
  },
  {
    name: "João Pereira",
    role: "Gerente - Supermercado Central",
    content:
      "Profissionalismo impecável. A documentação completa facilitou muito nossas auditorias da vigilância sanitária. Recomendo!",
    rating: 5,
  },
  {
    name: "Ana Costa",
    role: "Proprietária - Restaurante Sabor & Arte",
    content:
      "Trabalho sério e comprometido. Fazem manutenções preventivas regulares e nunca tivemos problemas com fiscalização. Equipe nota 10!",
    rating: 5,
  },
];

const clients = [
  "Condomínio Jardim Atlântico",
  "Supermercado Central",
  "Hospital São Lucas",
  "Shopping Recife Plaza",
  "Hotel Mar Azul",
  "Indústria Alimentos Norte",
];

const Testimonials = () => {
  return (
    <section className="py-20 bg-muted">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <h2 className="mb-4">O Que Nossos Clientes Dizem</h2>
          <p className="text-lg text-muted-foreground max-w-2xl mx-auto">
            A satisfação dos nossos clientes é o nosso maior orgulho.
          </p>
        </div>

        {/* Testimonials */}
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8 mb-16">
          {testimonials.map((testimonial, index) => (
            <Card
              key={testimonial.name}
              className="p-6 relative hover:shadow-lg transition-all duration-300 animate-fade-in-up"
              style={{ animationDelay: `${index * 100}ms` }}
            >
              <Quote className="absolute top-4 right-4 w-8 h-8 text-primary/20" />
              <div className="mb-4">
                <div className="flex space-x-1 mb-3">
                  {[...Array(testimonial.rating)].map((_, i) => (
                    <Star key={i} className="w-5 h-5 fill-primary text-primary" />
                  ))}
                </div>
                <p className="text-muted-foreground italic mb-4">"{testimonial.content}"</p>
              </div>
              <div className="border-t pt-4">
                <p className="font-bold">{testimonial.name}</p>
                <p className="text-sm text-muted-foreground">{testimonial.role}</p>
              </div>
            </Card>
          ))}
        </div>

        {/* Client Logos */}
        <div>
          <h3 className="text-2xl font-bold text-center mb-8">Clientes que Confiam em Nós</h3>
          <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-6">
            {clients.map((client, index) => (
              <div
                key={client}
                className="flex items-center justify-center p-4 bg-background rounded-lg hover:shadow-md transition-all animate-fade-in"
                style={{ animationDelay: `${index * 50}ms` }}
              >
                <p className="text-sm font-semibold text-center text-muted-foreground">
                  {client}
                </p>
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
};

export default Testimonials;
