import { Button } from "@/components/ui/button";
import { Card } from "@/components/ui/card";
import { Bug, Droplets, Sparkles, ArrowRight } from "lucide-react";
import desinsetizacaoImg from "@/assets/service-desinsetizacao.jpg";
import limpezaImg from "@/assets/service-limpeza.jpg";
import sanitizacaoImg from "@/assets/service-sanitizacao.jpg";

const services = [
  {
    title: "Desinsetização",
    description:
      "Controle eficaz de pragas urbanas como baratas, formigas, mosquitos e outros insetos. Métodos seguros e certificados.",
    icon: Bug,
    image: desinsetizacaoImg,
    features: ["Produtos certificados", "Equipe treinada", "Garantia de 3 meses"],
  },
  {
    title: "Limpeza de Reservatórios",
    description:
      "Higienização completa de caixas d'água e reservatórios conforme normas da Vigilância Sanitária.",
    icon: Droplets,
    image: limpezaImg,
    features: ["Conforme NR", "Laudo técnico", "Periodicidade programada"],
  },
  {
    title: "Sanitização",
    description:
      "Desinfecção profissional de ambientes comerciais, industriais e residenciais com produtos de alta eficácia.",
    icon: Sparkles,
    image: sanitizacaoImg,
    features: ["Eliminação 99,9%", "Secagem rápida", "Sem odores"],
  },
];

const Services = () => {
  const whatsappNumber = "5581999999999";

  return (
    <section id="servicos" className="bg-muted border-t-2 border-brand-red-divider">
      <div className="container mx-auto px-4 py-20">
        <div className="text-center mb-16">
          <h2 className="mb-4 animate-fade-in-up">Nossos Serviços</h2>
          <p className="text-lg text-muted-foreground max-w-2xl mx-auto animate-fade-in">
            Soluções completas em saúde ambiental com certificações técnicas e conformidade com todas
            as normas regulamentadoras.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          {services.map((service, index) => (
            <Card
              key={service.title}
              className="overflow-hidden border border-brand-red-muted/30 transition-all duration-200 hover:-translate-y-2 animate-fade-in-up motion-reduce:hover:-translate-y-0 flex flex-col h-full"
              style={{ 
                animationDelay: `${index * 100}ms`,
                boxShadow: '0 1px 3px 0 rgba(0, 0, 0, 0.05)',
                willChange: 'transform, box-shadow, border-color'
              }}
              onMouseEnter={(e) => {
                if (!window.matchMedia('(prefers-reduced-motion: reduce)').matches) {
                  e.currentTarget.style.boxShadow = '0 0 0 1px rgba(142, 0, 0, 0.15), 0 0 24px 0 rgba(142, 0, 0, 0.35), 0 4px 12px -2px rgba(142, 0, 0, 0.2)';
                  e.currentTarget.style.borderColor = 'rgba(142, 0, 0, 0.5)';
                }
              }}
              onMouseLeave={(e) => {
                e.currentTarget.style.boxShadow = '0 1px 3px 0 rgba(0, 0, 0, 0.05)';
                e.currentTarget.style.borderColor = '';
              }}
            >
              <div className="relative h-48 overflow-hidden">
                <img
                  src={service.image}
                  alt={service.title}
                  className="w-full h-full object-cover transition-transform duration-300 hover:scale-110"
                />
                <div className="absolute top-4 left-4 bg-primary text-primary-foreground p-3 rounded-full">
                  <service.icon className="w-6 h-6" />
                </div>
              </div>

              <div className="p-6 flex flex-col flex-grow">
                <h3 className="text-2xl font-bold mb-3">{service.title}</h3>
                <p className="text-muted-foreground mb-4">{service.description}</p>

                <ul className="space-y-2 mb-6">
                  {service.features.map((feature) => (
                    <li key={feature} className="flex items-center text-sm">
                      <ArrowRight className="w-4 h-4 text-primary mr-2 flex-shrink-0" />
                      {feature}
                    </li>
                  ))}
                </ul>

                <Button
                  variant="default"
                  className="w-full mt-auto"
                  asChild
                >
                  <a
                    href={`https://wa.me/${whatsappNumber}?text=Olá!%20Gostaria%20de%20um%20orçamento%20para%20${service.title}.`}
                    target="_blank"
                    rel="noopener noreferrer"
                  >
                    Pedir Orçamento
                  </a>
                </Button>
              </div>
            </Card>
          ))}
        </div>
      </div>
    </section>
  );
};

export default Services;
