export interface MenuItem {
  label: string;
  href: string;
}

export interface MenuColumn {
  title: string;
  items: MenuItem[];
}

export interface MenuCard {
  title: string;
  description: string;
  href: string;
}

export interface MegaMenuData {
  columns: MenuColumn[];
  cards: MenuCard[];
}

export interface NavItem {
  label: string;
  href: string;
  mega?: MegaMenuData;
}

export const MENU_DATA: Record<string, NavItem> = {
  servicos: {
    label: 'Serviços',
    href: '/servicos',
    mega: {
      columns: [
        {
          title: 'CONTROLE DE PRAGAS',
          items: [
            { label: 'Desinsetização', href: '/servicos#desinsetizacao' },
            { label: 'Desratização', href: '/servicos#desratizacao' },
            { label: 'Descupinização', href: '/servicos#descupinizacao' },
            { label: 'Controle de Formigas', href: '/servicos#formigas' },
            { label: 'Controle de Pombos', href: '/servicos#pombos' },
            { label: 'Controle de Escorpiões', href: '/servicos#escorpioes' },
          ],
        },
        {
          title: 'HIGIENIZAÇÃO',
          items: [
            { label: 'Limpeza de Reservatórios', href: '/servicos#limpeza' },
            { label: 'Sanitização', href: '/servicos#sanitizacao' },
            { label: 'Desinfecção', href: '/servicos#desinfeccao' },
            { label: 'Higienização Industrial', href: '/servicos#industrial' },
            { label: 'Limpeza de Caixa d\'Água', href: '/servicos#caixa-agua' },
            { label: 'Higiênização de Dutos', href: '/servicos#dutos' },
          ],
        },
        {
          title: 'LAUDOS / LICENÇAS',
          items: [
            { label: 'Laudos Técnicos', href: '/servicos#laudos' },
            { label: 'Licenças Ambientais', href: '/servicos#licencas' },
            { label: 'Certificados de Serviço', href: '/servicos#certificados' },
            { label: 'Documentação Técnica', href: '/servicos#documentacao' },
            { label: 'Relatórios de Inspeção', href: '/servicos#relatorios' },
            { label: 'Conformidade Legal', href: '/servicos#conformidade' },
          ],
        },
      ],
      cards: [
        {
          title: 'Peça um Orçamento',
          description: 'Solicite uma visita técnica gratuita e receba um orçamento personalizado em até 2 horas.',
          href: '/contato',
        },
        {
          title: 'Fale com Especialista',
          description: 'Nossa equipe está pronta para esclarecer suas dúvidas sobre nossos serviços.',
          href: '/contato',
        },
      ],
    },
  },
  galeria: {
    label: 'Galeria',
    href: '/galeria',
  },
  eventos: {
    label: 'Eventos',
    href: '/eventos',
    mega: {
      columns: [
        {
          title: 'TREINAMENTOS',
          items: [
            { label: 'NR 33 - Espaço Confinado', href: '/eventos?categoria=treinamento&tipo=nr33' },
            { label: 'NR 35 - Trabalho em Altura', href: '/eventos?categoria=treinamento&tipo=nr35' },
            { label: 'Controle de Pragas', href: '/eventos?categoria=treinamento&tipo=controle-pragas' },
            { label: 'Segurança do Trabalho', href: '/eventos?categoria=treinamento&tipo=seguranca' },
            { label: 'Uso de EPIs', href: '/eventos?categoria=treinamento&tipo=epis' },
            { label: 'Técnicas Especializadas', href: '/eventos?categoria=treinamento&tipo=tecnicas' },
          ],
        },
        {
          title: 'AÇÕES PREVENTIVAS',
          items: [
            { label: 'Campanhas de Conscientização', href: '/eventos?categoria=acoes&tipo=campanhas' },
            { label: 'Palestras Educativas', href: '/eventos?categoria=acoes&tipo=palestras' },
            { label: 'Workshops', href: '/eventos?categoria=acoes&tipo=workshops' },
            { label: 'Inspeções Preventivas', href: '/eventos?categoria=acoes&tipo=inspecoes' },
            { label: 'Programas de Prevenção', href: '/eventos?categoria=acoes&tipo=programas' },
            { label: 'Eventos Corporativos', href: '/eventos?categoria=acoes&tipo=corporativos' },
          ],
        },
        {
          title: 'CALENDÁRIO',
          items: [
            { label: 'Próximos Eventos', href: '/eventos?filtro=proximos' },
            { label: 'Eventos Passados', href: '/eventos?filtro=passados' },
            { label: 'Agenda de Treinamentos', href: '/eventos?filtro=treinamentos' },
            { label: 'Feiras e Exposições', href: '/eventos?filtro=feiras' },
            { label: 'Calendário Completo', href: '/eventos' },
            { label: 'Inscreva-se', href: '/eventos?acao=inscrever' },
          ],
        },
      ],
      cards: [
        {
          title: 'Próximo Evento',
          description: 'NR 33 - Espaço Confinado. Capacite sua equipe com nossos treinamentos certificados.',
          href: '/eventos',
        },
        {
          title: 'Agende um Evento',
          description: 'Organize um treinamento ou palestra para sua empresa. Entre em contato!',
          href: '/contato',
        },
      ],
    },
  },
};

// Itens simples sem mega menu
export const SIMPLE_NAV_ITEMS: NavItem[] = [
  { label: 'Sobre Nós', href: '/quem-somos' },
  { label: 'Contato', href: '/contato' },
];
