# 🚀 Guia de Instalação e Configuração Local

Este guia vai te ajudar a configurar e rodar o site da Hecol Saúde Ambiental na sua máquina local.

## 📋 Pré-requisitos

Antes de começar, certifique-se de ter instalado:

- **Node.js** (versão 18 ou superior) - [Download aqui](https://nodejs.org/)
- **npm** (vem com Node.js) ou **yarn** ou **pnpm**
- **Git** (para clonar o repositório, se necessário)

### Verificar Instalação

Abra o terminal (PowerShell no Windows) e execute:

```bash
node --version
npm --version
```

Se ambos comandos retornarem números de versão, você está pronto!

---

## 🔧 Passo a Passo de Instalação

### 1. Instalar Dependências

No diretório do projeto, execute:

```bash
npm install
```

Isso vai instalar todas as dependências necessárias (React, TypeScript, Tailwind, etc.).

**Tempo estimado:** 2-5 minutos (dependendo da sua conexão)

### 2. Configurar Variáveis de Ambiente

#### 2.1. Criar arquivo `.env.local`

Copie o arquivo de exemplo:

```bash
# No Windows (PowerShell)
Copy-Item .env.example .env.local

# No Linux/Mac
cp .env.example .env.local
```

#### 2.2. Editar `.env.local`

Abra o arquivo `.env.local` e configure as variáveis:

**Para desenvolvimento básico (sem Supabase):**
```env
# Deixe vazio ou use valores de teste
VITE_SUPABASE_URL=
VITE_SUPABASE_PUBLISHABLE_KEY=
```

**Se você tem Supabase:**
1. Acesse [https://supabase.com](https://supabase.com)
2. Crie um projeto (ou use um existente)
3. Vá em Settings > API
4. Copie a URL e a chave pública
5. Cole no `.env.local`

```env
VITE_SUPABASE_URL=https://seu-projeto.supabase.co
VITE_SUPABASE_PUBLISHABLE_KEY=sua-chave-publica-aqui
```

> **Nota:** O site funciona sem Supabase, mas algumas funcionalidades (como área do cliente) podem não funcionar completamente.

### 3. Rodar o Servidor de Desenvolvimento

Execute:

```bash
npm run dev
```

Você verá algo como:

```
  VITE v5.4.19  ready in 500 ms

  ➜  Local:   http://localhost:8080/
  ➜  Network: use --host to expose
```

### 4. Acessar o Site

Abra seu navegador e acesse:

**http://localhost:8080**

🎉 **Pronto!** O site está rodando na sua máquina!

---

## 🛠️ Scripts Disponíveis

### Desenvolvimento
```bash
npm run dev
```
Inicia o servidor de desenvolvimento com hot-reload (mudanças aparecem automaticamente).

### Build para Produção
```bash
npm run build
```
Cria uma versão otimizada do site na pasta `dist/`.

### Preview da Build
```bash
npm run preview
```
Testa a versão de produção localmente antes de fazer deploy.

### Lint (Verificar Código)
```bash
npm run lint
```
Verifica problemas no código.

---

## 🔍 Solução de Problemas

### Erro: "Cannot find module"
```bash
# Delete node_modules e reinstale
rm -rf node_modules
npm install
```

### Porta 8080 já está em uso
Edite `vite.config.ts` e mude a porta:
```typescript
server: {
  port: 3000, // ou outra porta disponível
}
```

### Erro de variáveis de ambiente
- Certifique-se de que o arquivo se chama `.env.local` (não `.env.local.txt`)
- Reinicie o servidor após alterar variáveis de ambiente
- No Windows, certifique-se de que o arquivo não está oculto

### Erro de TypeScript
```bash
# Limpar cache do TypeScript
rm -rf node_modules/.vite
npm run dev
```

### Problemas com dependências
```bash
# Limpar tudo e reinstalar
rm -rf node_modules package-lock.json
npm install
```

---

## 📁 Estrutura do Projeto

```
controle-certos-site-38617-37227-41818-main/
├── src/                    # Código fonte
│   ├── components/         # Componentes React
│   ├── pages/              # Páginas do site
│   ├── lib/                # Bibliotecas e utilitários
│   ├── hooks/              # Custom hooks
│   └── config/             # Configurações
├── public/                 # Arquivos estáticos
├── .env.local              # Variáveis de ambiente (criar você)
├── package.json            # Dependências do projeto
└── vite.config.ts          # Configuração do Vite
```

---

## 🎨 Desenvolvimento

### Hot Reload
O Vite tem hot-reload automático. Quando você salvar um arquivo:
- Mudanças em componentes React aparecem instantaneamente
- Mudanças em CSS são aplicadas sem recarregar
- Mudanças em configurações podem precisar de restart

### Estrutura de Componentes
- `src/components/home/` - Componentes da página inicial
- `src/components/layout/` - Header, Footer, etc.
- `src/components/ui/` - Componentes reutilizáveis (shadcn/ui)
- `src/pages/` - Páginas principais do site

### Adicionar Nova Página
1. Crie um arquivo em `src/pages/NovaPagina.tsx`
2. Adicione a rota em `src/App.tsx`:
```typescript
<Route path="/nova-pagina" element={<NovaPagina />} />
```

---

## 🔐 Configurações Opcionais

### Google Analytics
1. Crie uma conta no [Google Analytics](https://analytics.google.com)
2. Obtenha seu Measurement ID (formato: G-XXXXXXXXXX)
3. Adicione no `.env.local`:
```env
VITE_GA_MEASUREMENT_ID=G-XXXXXXXXXX
```

### Google Maps
1. Obtenha uma API Key no [Google Cloud Console](https://console.cloud.google.com)
2. Adicione no `.env.local`:
```env
VITE_GOOGLE_MAPS_API_KEY=sua-chave-aqui
```

---

## 📚 Recursos Úteis

- **Documentação do React:** https://react.dev
- **Documentação do Vite:** https://vitejs.dev
- **Documentação do Tailwind:** https://tailwindcss.com
- **shadcn/ui:** https://ui.shadcn.com

---

## 🆘 Precisa de Ajuda?

Se encontrar problemas:
1. Verifique se todas as dependências foram instaladas
2. Certifique-se de que está usando Node.js 18+
3. Verifique os logs de erro no terminal
4. Consulte a seção "Solução de Problemas" acima

---

**Boa sorte com o desenvolvimento! 🚀**
