# Saúde Ambiental - Site Institucional

Site institucional completo para empresa de saúde ambiental (controle de pragas e higienização) desenvolvido com React, TypeScript, Tailwind CSS e shadcn/ui.

## 🚀 Funcionalidades

### Páginas Principais
- **Home**: Hero section, serviços, números, certificações, depoimentos
- **Quem Somos**: História, missão/visão/valores, equipe técnica
- **Serviços**: Detalhamento completo de desinsetização, limpeza de reservatórios e sanitização
- **Galeria**: Portfolio de trabalhos com filtros por categoria e antes/depois
- **Eventos**: Agenda de feiras, treinamentos e ações sociais
- **Área do Cliente**: Login e download de certificados em PDF
- **Trabalhe Conosco**: Vagas abertas e formulário de candidatura
- **Contato**: Formulário de contato, mapa e informações

### Características Técnicas
- 🎨 Design system completo com tokens semânticos (preto, vermelho, branco, azul escuro)
- 📱 Totalmente responsivo (mobile-first)
- ♿ Acessível (navegação por teclado, contraste AA, textos alternativos)
- ⚡ Performance otimizada (lazy loading, animações suaves)
- 🔍 SEO otimizado (metatags, Open Graph, sitemap)
- 🛡️ LGPD compliant (formulários com consentimento)

## 🛠️ Tecnologias

- **React 18** com TypeScript
- **Vite** para build e dev server
- **Tailwind CSS** para estilização
- **shadcn/ui** para componentes UI
- **React Router** para roteamento
- **Lucide React** para ícones

## 📦 Instalação

### Pré-requisitos
- Node.js 18+ ([Download](https://nodejs.org/))
- npm (vem com Node.js)

### Passos Rápidos

```bash
# 1. Instalar dependências
npm install

# 2. Configurar variáveis de ambiente
# Copie .env.example para .env.local e configure (opcional para desenvolvimento básico)
Copy-Item .env.example .env.local  # Windows PowerShell
# ou
cp .env.example .env.local        # Linux/Mac

# 3. Rodar em desenvolvimento
npm run dev

# O site estará disponível em: http://localhost:8080
```

### Scripts Disponíveis

```bash
npm run dev        # Servidor de desenvolvimento
npm run build       # Build para produção
npm run preview     # Preview da build
npm run lint        # Verificar código
```

> 📖 **Para instruções detalhadas, consulte [SETUP.md](./SETUP.md)**

## 🎨 Design System

### Cores Principais
- **Preto**: `#0B0B0B` - Textos e fundos corporativos
- **Vermelho**: `#D32F2F` - CTAs e destaques
- **Branco**: `#FFFFFF` - Contraste e espaços
- **Azul Escuro**: `#0E1B2E` - Elementos secundários

### Componentes Personalizados
- Button variants: `hero`, `cta`, `whatsapp`
- Cards com hover effects
- Contadores animados
- Formulários com validação

## 📄 Estrutura de Páginas

```
/                    - Home
/quem-somos          - Sobre a empresa
/servicos            - Detalhamento dos serviços
/galeria             - Portfolio de trabalhos
/eventos             - Agenda de eventos
/cliente             - Área do cliente (login)
/trabalhe-conosco    - Vagas e candidatura
/contato             - Formulário de contato
```

## 🔐 Área do Cliente

A área do cliente permite login e acesso a certificados de serviços prestados:

**Login de Demonstração:**
- E-mail: qualquer@email.com
- Senha: qualquer senha

> Nota: Sistema de autenticação é mockado para demonstração. Integração com backend real deve ser implementada.

## 📞 Integrações

### WhatsApp
Botões de CTA integrados com WhatsApp Business para contato direto.
Número configurado: `5581999999999` (alterar em produção)

### Formulários
- Validação client-side
- Consentimento LGPD obrigatório
- Toast notifications para feedback

## 🌐 SEO

Cada página possui:
- Title tags otimizadas
- Meta descriptions únicas
- Heading hierarchy (H1 único por página)
- Alt text em imagens
- Structured data preparado

## 🚢 Deploy

O projeto está pronto para deploy em:
- Vercel (recomendado)
- Netlify
- GitHub Pages (com adaptações)
- Qualquer plataforma que suporte sites estáticos

## 📝 Próximos Passos

### Backend
- [ ] Implementar autenticação real
- [ ] Banco de dados para certificados
- [ ] Sistema de upload de PDFs
- [ ] API para formulários
- [ ] Integração com e-mail (nodemailer)

### Melhorias Futuras
- [ ] Blog/notícias
- [ ] Chat online
- [ ] Agendamento online
- [ ] Dashboard administrativo
- [ ] Sistema de avaliações

## 🔒 LGPD e Segurança

- Consentimento explícito em todos os formulários
- Política de privacidade (criar página dedicada)
- Termos de uso (criar página dedicada)
- Rate limiting nos formulários (implementar)
- reCAPTCHA (adicionar)

## 📞 Suporte

Para dúvidas sobre o projeto:
- Email: contato@saudeambiental.com.br
- WhatsApp: (81) 99999-9999

## 📄 Licença

© 2025 Hecol Saúde Ambiental. Todos os direitos reservados.
